﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace Gebrauchtbootsverkauf
{
    /// <summary>
    /// Interaction logic for bootsDetails.xaml
    /// </summary>
    public partial class BootsDetails : Window
    {
        public BootsDetails(Object selBoot)
        {
            InitializeComponent         (); // Vorgaberoutine

            Boot gew_Boot = (Boot) selBoot; // Eingabe als Bootsobjekt verarbeiten

            // Dialogfenster mit entsprechendne Daten u. dem Bild füllen

            this.Title     =                           gew_Boot.Modell;
            Modell.Content =                           gew_Boot.Modell;
            Sitze.Content  =                           gew_Boot.Sitze ;
            Preis.Content  = string.Format("{0:N2} €", gew_Boot.Preis); // Preis geschönt formatieren mit 2 Dezimalstellen...
            
            Image img = new Image(); // Bild anlegen

            var pic_resource = new Uri("pack://application:,,,/pics/" +         gew_Boot.Bilddatei); // jeweilige Bilddatei einbinden
            img.Source       = new BitmapImage                                       (pic_resource); // anhand der jeweiligen Resource
            pic.Content      = img                                                                 ; // d. Dialogfenster zuweisen

            if ( gew_Boot.GetType() == typeof(Segelboot) )                                           // war es ein Segelboot?
               {
               Segelboot SegBt =                                                 (Segelboot)selBoot;
               Zusatzinfo.Content = "Das Boot hat eine Segelfläche von " + SegBt.Flaeche + " qm"   ; // Segelfläche im Zusatzfeld als Extra ausgeben
               return                                                                              ; // Standardzusatzinfomeldung überspringen
               }

            if ( gew_Boot.GetType() == typeof(Motorboot) )                                           // war es ein Motorboot?
               {
               Motorboot MotBt =                                                 (Motorboot)selBoot;
               Zusatzinfo.Content = "Das Boot hat eine Motorleistung von " + MotBt.Leistung + " PS"; // Motorleistung im Zusatzfeld als Extra ausgeben
               return                                                                              ; // Standardzusatzinfomeldung überspringen
               }

            Zusatzinfo.Content = "Standardausführung"                                              ; // wenn oben keine Zusatzinfos (Extraustattungen) vorliegen, Standardmeldung machen im Zusatzfeld
        }
    }
}
